/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.cec;

import com.quantumdata.cec.CECComplianceMain;
import com.quantumdata.std.xml.DbNode;
import com.quantumdata.widgets.QDCheckBox;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormatSymbols;
import java.util.Scanner;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.text.MaskFormatter;

public class CECComplianceCDFFeaturesMessages
extends QDPanel {
    private static final long serialVersionUID = 1L;
    private static final String[] cecVersionList = new String[]{"1.1", "1.2", "1.2A", "1.3", "1.3A"};
    private static final String[] standbyMethods = new String[]{"None, must be done manually", "<Image View On>", "<Text View On>", "<User Control Pressed>[0x40]", "<User Control Pressed>[0x6B]", "<User Control Pressed>[0x6D]", "<Active Source>", "<Play>[\"Play Forward\"]", "<Deck Control>[\"Eject\"]"};
    private JComboBox cecVersionBox = new JComboBox();
    private JComboBox outOfStandbyBox = new JComboBox();
    private JComboBox externalPlugNum = new JComboBox();
    private JComboBox timerDay = new JComboBox();
    private JComboBox timerMonth;
    private JFormattedTextField externalPA;
    private JFormattedTextField[] digitalTuner;
    private JFormattedTextField[] analogTuner;
    private JFormattedTextField vendorID;
    private JFormattedTextField badVendorID;
    private JFormattedTextField osdName;
    private QDCheckBox digitalTunerBox;
    private QDCheckBox analogTunerBox;
    private QDCheckBox dutOutOfStandby;
    private QDCheckBox twoConsecutiveMsgs;
    private QDCheckBox oneTouchPlay;
    private QDCheckBox oneTouchRecord;
    private QDCheckBox hasInternalSource;
    private QDCheckBox hasTextMode;
    private QDCheckBox routingControl;
    private QDCheckBox standbyFeature;
    private QDCheckBox timerProgramming;
    private QDCheckBox systemInformation;
    private QDCheckBox deckControl;
    private QDCheckBox deckStatusOn;
    private QDCheckBox deckStatusOff;
    private QDCheckBox deckStatusOnce;
    private QDCheckBox tunerDeviceStatusOn;
    private QDCheckBox tunerDeviceStatusOff;
    private QDCheckBox tunerDeviceStatusOnce;
    private QDCheckBox supportRCPassToRecDevOnActive;
    private QDCheckBox supportRCPassToPlayDevOnActive;
    private QDCheckBox supportRCPassToTunerOnActive;
    private QDCheckBox supportRCPassToAudioSysOnActive;
    private QDCheckBox supportRCPassToRecDev;
    private QDCheckBox supportRCPassToPlayDev;
    private QDCheckBox supportRCPassToTuner;
    private QDCheckBox supportRCPassToAudioSys;
    private QDCheckBox supportRCPassToTV;
    private QDCheckBox supportReportPowerStandbyInit;
    private QDCheckBox supportReportPowerStandbyFollow;
    private QDCheckBox tunerControl;
    private QDCheckBox vendorSpecific;
    private QDCheckBox osdDisplay;
    private QDCheckBox deviceOsdTransfer;
    private QDCheckBox deviceMenuControl;
    private QDCheckBox rcPassthrough;
    private QDCheckBox powerStatus;
    private QDCheckBox featureAbort;
    private QDCheckBox systemAudioControl;
    private QDCheckBox audioRateControl;
    private QDCheckBox sendsVendorCommandsToOtherVendors;
    private QDCheckBox wideAudioRateControl;
    private QDCheckBox narrowAudioRateControl;
    private QDCheckBox[] initiatorOpcodes;
    private QDCheckBox[] followerOpcodes;
    private QDCheckBox[] recordOnInitiator;
    private QDCheckBox[] recordOnFollower;
    private QDCheckBox[] standbyInitiator;
    private QDCheckBox[] standbyFollower;
    private QDCheckBox[] extTimerInitiator;
    private QDCheckBox[] extTimerFollower;
    private QDCheckBox pollingInitiator;
    private QDCheckBox pollingFollower;
    private JTextField deckControlOperands;
    private JTextField deckStatusOperands;
    private JTextField playOperands;
    private JTextField[] rcPassActiveOperands;
    private JTextField[] rcPassOperands;
    private JTextField supportedLanguages;
    private static final String operandToolTip = "<HTML>In this field, you can enter<br>values (such as '0x09') or ranges<br>(such as '0x09-0x0F') separated<br>by commas.<br><b>Example:</b> '0x03, 0x09-0x14, 0x23'";

    public CECComplianceCDFFeaturesMessages() {
        int n;
        int n2;
        for (int i = 0; i < 31; ++i) {
            this.timerDay.addItem("" + (i + 1));
        }
        this.timerMonth = new JComboBox();
        String[] stringArray = new DateFormatSymbols().getMonths();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2].length() <= 0) continue;
            this.timerMonth.addItem(stringArray[n2]);
        }
        this.externalPA = new JFormattedTextField();
        this.digitalTuner = new JFormattedTextField[2];
        this.analogTuner = new JFormattedTextField[2];
        for (n2 = 0; n2 < 2; ++n2) {
            this.digitalTuner[n2] = new JFormattedTextField();
            this.analogTuner[n2] = new JFormattedTextField();
        }
        this.vendorID = new JFormattedTextField();
        this.badVendorID = new JFormattedTextField();
        this.osdName = new JFormattedTextField();
        try {
            MaskFormatter maskFormatter = new MaskFormatter("H.H.H.H");
            maskFormatter.setPlaceholderCharacter('0');
            this.externalPA = new JFormattedTextField(maskFormatter);
            this.externalPA.setColumns(16);
            maskFormatter = new MaskFormatter(" HH HH HH HH ");
            maskFormatter.setPlaceholderCharacter('0');
            this.analogTuner[0] = new JFormattedTextField(maskFormatter);
            this.analogTuner[1] = new JFormattedTextField(maskFormatter);
            this.analogTuner[0].setColumns(16);
            this.analogTuner[1].setColumns(16);
            maskFormatter = new MaskFormatter(" HH HH HH HH HH HH HH ");
            maskFormatter.setPlaceholderCharacter('0');
            this.digitalTuner[0] = new JFormattedTextField(maskFormatter);
            this.digitalTuner[1] = new JFormattedTextField(maskFormatter);
            this.digitalTuner[0].setColumns(16);
            this.digitalTuner[1].setColumns(16);
            maskFormatter = new MaskFormatter(" HH HH HH ");
            maskFormatter.setPlaceholderCharacter('0');
            this.vendorID = new JFormattedTextField(maskFormatter);
            this.badVendorID = new JFormattedTextField(maskFormatter);
            this.vendorID.setColumns(16);
            this.badVendorID.setColumns(16);
            maskFormatter = new MaskFormatter("**************");
            maskFormatter.setPlaceholderCharacter(' ');
            this.osdName = new JFormattedTextField(maskFormatter);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.digitalTunerBox = new QDCheckBox();
        this.analogTunerBox = new QDCheckBox();
        this.dutOutOfStandby = new QDCheckBox();
        this.twoConsecutiveMsgs = new QDCheckBox();
        this.oneTouchPlay = new QDCheckBox();
        this.oneTouchRecord = new QDCheckBox();
        this.hasInternalSource = new QDCheckBox();
        this.hasTextMode = new QDCheckBox();
        this.routingControl = new QDCheckBox();
        this.standbyFeature = new QDCheckBox();
        this.timerProgramming = new QDCheckBox();
        this.systemInformation = new QDCheckBox();
        this.deckControl = new QDCheckBox();
        this.deckStatusOn = new QDCheckBox();
        this.deckStatusOff = new QDCheckBox();
        this.deckStatusOnce = new QDCheckBox();
        this.tunerDeviceStatusOn = new QDCheckBox();
        this.tunerDeviceStatusOff = new QDCheckBox();
        this.tunerDeviceStatusOnce = new QDCheckBox();
        this.supportRCPassToRecDevOnActive = new QDCheckBox();
        this.supportRCPassToPlayDevOnActive = new QDCheckBox();
        this.supportRCPassToTunerOnActive = new QDCheckBox();
        this.supportRCPassToAudioSysOnActive = new QDCheckBox();
        this.supportRCPassToRecDev = new QDCheckBox();
        this.supportRCPassToPlayDev = new QDCheckBox();
        this.supportRCPassToTuner = new QDCheckBox();
        this.supportRCPassToAudioSys = new QDCheckBox();
        this.supportRCPassToTV = new QDCheckBox();
        this.supportReportPowerStandbyInit = new QDCheckBox();
        this.supportReportPowerStandbyFollow = new QDCheckBox();
        this.tunerControl = new QDCheckBox();
        this.vendorSpecific = new QDCheckBox();
        this.osdDisplay = new QDCheckBox();
        this.deviceOsdTransfer = new QDCheckBox();
        this.deviceMenuControl = new QDCheckBox();
        this.rcPassthrough = new QDCheckBox();
        this.powerStatus = new QDCheckBox();
        this.featureAbort = new QDCheckBox();
        this.systemAudioControl = new QDCheckBox();
        this.audioRateControl = new QDCheckBox();
        this.sendsVendorCommandsToOtherVendors = new QDCheckBox();
        this.wideAudioRateControl = new QDCheckBox();
        this.narrowAudioRateControl = new QDCheckBox();
        this.initiatorOpcodes = new QDCheckBox[256];
        this.followerOpcodes = new QDCheckBox[256];
        for (n = 0; n < 256; ++n) {
            this.initiatorOpcodes[n] = new QDCheckBox();
            this.followerOpcodes[n] = new QDCheckBox();
        }
        this.recordOnInitiator = new QDCheckBox[5];
        this.recordOnFollower = new QDCheckBox[5];
        for (n = 0; n < 5; ++n) {
            this.recordOnInitiator[n] = new QDCheckBox();
            this.recordOnFollower[n] = new QDCheckBox();
        }
        this.standbyInitiator = new QDCheckBox[2];
        this.standbyFollower = new QDCheckBox[2];
        this.extTimerInitiator = new QDCheckBox[2];
        this.extTimerFollower = new QDCheckBox[2];
        for (n = 0; n < 2; ++n) {
            this.standbyInitiator[n] = new QDCheckBox();
            this.standbyFollower[n] = new QDCheckBox();
            this.extTimerInitiator[n] = new QDCheckBox();
            this.extTimerFollower[n] = new QDCheckBox();
        }
        this.pollingInitiator = new QDCheckBox();
        this.pollingFollower = new QDCheckBox();
        this.deckControlOperands = new JTextField();
        this.deckStatusOperands = new JTextField();
        this.playOperands = new JTextField();
        this.rcPassActiveOperands = new JTextField[4];
        this.rcPassOperands = new JTextField[6];
        for (n = 0; n < 4; ++n) {
            this.rcPassActiveOperands[n] = new JTextField();
        }
        for (n = 0; n < 6; ++n) {
            this.rcPassOperands[n] = new JTextField();
        }
        this.supportedLanguages = new JTextField();
        this.init();
    }

    private void init() {
        int n;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        gridBagConstraints.gridy = 12;
        this.AddTunerInfo("Does the DUT have a Digital tuner?", this.digitalTunerBox, this.digitalTuner, "<HTML>Please write two typical Digital Service<br>Identifications in hexadecimal that the DUT<br>can display and how to select the service<br>using the DUT's control.</HTML>", 2, gridBagConstraints);
        this.AddTunerInfo("Does the DUT have an Analogue tuner?", this.analogTunerBox, this.analogTuner, "<HTML>Please write two typical Analogue Service<br>Identifications in hexadecimal that the DUT<br>can display and how to select the service<br>using the DUT's control.</HTML>", 2, gridBagConstraints);
        this.YesNoQuestion("Can DUT be brought out of Standby?", this.dutOutOfStandby, gridBagConstraints);
        for (n = 0; n < standbyMethods.length; ++n) {
            this.outOfStandbyBox.addItem(standbyMethods[n]);
        }
        gridBagConstraints.gridx = 2;
        this.add((Component)new QDLabel("   Method to bring out of standby"), gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.anchor = 10;
        this.add((Component)this.outOfStandbyBox, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        this.YesNoQuestion("<HTML>Can DUT send two<br>consecutive messages?</HTML>", this.twoConsecutiveMsgs, gridBagConstraints);
        this.YesNoSectionQuestion("One Touch Play", this.oneTouchPlay, gridBagConstraints, true);
        this.YesNoQuestion("Does DUT (TV) have an internal source?", this.hasInternalSource, gridBagConstraints);
        this.YesNoQuestion("Does DUT (TV) have a text mode?", this.hasTextMode, gridBagConstraints);
        this.YesNoOpcodeQuestion("Active Source", 130, gridBagConstraints);
        this.YesNoOpcodeQuestion("Image View On", 4, gridBagConstraints);
        this.YesNoOpcodeQuestion("Text View On", 13, gridBagConstraints);
        this.YesNoSectionQuestion("Routing Control", this.routingControl, gridBagConstraints, true);
        this.YesNoOpcodeQuestion("Request Active Source", 133, gridBagConstraints);
        this.YesNoOpcodeQuestion("Routing Change", 128, gridBagConstraints);
        this.YesNoOpcodeQuestion("Routing Information", 129, gridBagConstraints);
        this.YesNoOpcodeQuestion("Set Stream Path", 134, gridBagConstraints);
        this.YesNoOpcodeQuestion("Inactive Source", 157, gridBagConstraints);
        this.YesNoSectionQuestion("Standby", this.standbyFeature, gridBagConstraints, false);
        this.GenericYesNoDoubleQuestion("<Standby>(Directly Addressed)", "Initiator?", "Follower?", this.standbyInitiator[0], this.standbyFollower[0], gridBagConstraints);
        this.GenericYesNoDoubleQuestion("<Standby>(Broadcast)", "Initiator?", "Follower?", this.standbyInitiator[1], this.standbyFollower[1], gridBagConstraints);
        this.YesNoSectionQuestion("One Touch Record", this.oneTouchRecord, gridBagConstraints, false);
        this.YesNoOpcodeQuestion("Record Off", 11, gridBagConstraints);
        this.GenericYesNoDoubleQuestion("<Record On>[\"Own Source\"]", "Initiator?", "Follower?", this.recordOnInitiator[0], this.recordOnFollower[0], gridBagConstraints);
        this.GenericYesNoDoubleQuestion("<Record On>[\"Digital Service\"]", "Initiator?", "Follower?", this.recordOnInitiator[1], this.recordOnFollower[1], gridBagConstraints);
        this.GenericYesNoDoubleQuestion("<Record On>[\"Analogue Service\"]", "Initiator?", "Follower?", this.recordOnInitiator[2], this.recordOnFollower[2], gridBagConstraints);
        this.GenericYesNoDoubleQuestion("<Record On>[\"External Plug\"]", "Initiator?", "Follower?", this.recordOnInitiator[3], this.recordOnFollower[3], gridBagConstraints);
        this.GenericYesNoDoubleQuestion("<Record On>[\"External Physical Address\"]", "Initiator?", "Follower?", this.recordOnInitiator[4], this.recordOnFollower[4], gridBagConstraints);
        this.YesNoOpcodeQuestion("Record Status", 10, gridBagConstraints);
        this.YesNoOpcodeQuestion("Record TV Screen", 15, gridBagConstraints);
        this.YesNoSectionQuestion("Timer Programming", this.timerProgramming, gridBagConstraints, false);
        gridBagConstraints.gridx = 2;
        this.add((Component)new QDLabel("   Date to test timer with"), gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.timerDay, gridBagConstraints);
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridwidth = 4;
        this.add((Component)this.timerMonth, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        this.YesNoOpcodeQuestion("Clear Analogue Timer", 51, gridBagConstraints);
        this.YesNoOpcodeQuestion("Clear Digital Timer", 153, gridBagConstraints);
        this.YesNoOpcodeQuestion("Clear External Timer", 161, gridBagConstraints);
        this.YesNoOpcodeQuestion("Set Analogue Timer", 52, gridBagConstraints);
        this.YesNoOpcodeQuestion("Set Digital Timer", 151, gridBagConstraints);
        this.GenericYesNoDoubleQuestion("<Set External Timer>[...][\"External Plug\"]", "Initiator?", "Follower?", this.extTimerInitiator[0], this.extTimerFollower[0], gridBagConstraints);
        for (n = 0; n < 20; ++n) {
            this.externalPlugNum.addItem("" + n);
        }
        gridBagConstraints.gridx = 2;
        this.add((Component)new QDLabel("   Typical External Plug #"), gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.anchor = 10;
        this.add((Component)this.externalPlugNum, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.GenericYesNoDoubleQuestion("<Set External Timer>[...][\"External Physical Address\"]", "Initiator?", "Follower?", this.extTimerInitiator[1], this.extTimerFollower[1], gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        this.add((Component)new QDLabel("   Typical External Physical Address"), gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 10;
        this.externalPA.setColumns(7);
        this.add((Component)this.externalPA, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        this.YesNoOpcodeQuestion("Set Timer Program Title", 103, gridBagConstraints);
        this.YesNoOpcodeQuestion("Timer Cleared Status", 67, gridBagConstraints);
        this.YesNoOpcodeQuestion("Timer Status", 53, gridBagConstraints);
        this.YesNoSectionQuestion("System Information", this.systemInformation, gridBagConstraints, false);
        this.TextRow("<HTML>Languages Supported<br>(Supported Operands for<br>&lt;Set Menu Language&gt;)<br>(See ISO/FDIS 639-2)</HTML>", "<HTML>Separate with<br>commas and/or<br>spaces.</HTML>", this.supportedLanguages, gridBagConstraints);
        this.YesNoOpcodeQuestion("Get Menu Language", 145, gridBagConstraints);
        this.YesNoOpcodeQuestion("Give Physical Address", 131, gridBagConstraints);
        this.GenericYesNoDoubleQuestion("<Polling Message>", "Initiator?", "Follower?", this.pollingInitiator, this.pollingFollower, gridBagConstraints);
        this.YesNoOpcodeQuestion("Report Physical Address", 132, gridBagConstraints);
        this.YesNoOpcodeQuestion("Set Menu Language", 50, gridBagConstraints);
        this.YesNoOpcodeQuestion("Get CEC Version", 159, gridBagConstraints);
        this.YesNoOpcodeQuestion("CEC Version", 158, gridBagConstraints);
        for (n = 0; n < cecVersionList.length; ++n) {
            this.cecVersionBox.addItem(cecVersionList[n]);
        }
        this.cecVersionBox.setSelectedIndex(this.cecVersionBox.getItemCount() - 1);
        gridBagConstraints.gridx = 2;
        this.add((Component)new QDLabel("   CEC Version"), gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.anchor = 10;
        this.add((Component)this.cecVersionBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.deckControlOperands.setToolTipText(operandToolTip);
        this.deckStatusOperands.setToolTipText(operandToolTip);
        this.playOperands.setToolTipText(operandToolTip);
        this.YesNoSectionQuestion("Deck Control", this.deckControl, gridBagConstraints, false);
        this.YesNoOpcodeQuestion("Deck Control", 66, gridBagConstraints);
        this.TextRow("   Supported Operands?", "(0x01 - 0x04)", this.deckControlOperands, gridBagConstraints);
        this.YesNoOpcodeQuestion("Deck Status", 27, gridBagConstraints);
        this.TextRow("   Supported Operands?", "(0x11 - 0x1F)", this.deckStatusOperands, gridBagConstraints);
        this.YesNoOpcodeQuestion("Give Deck Status", 26, gridBagConstraints);
        this.GenericYesNoTripleQuestion("   Supported Operands?", "On", "Off", "Once", this.deckStatusOn, this.deckStatusOff, this.deckStatusOnce, gridBagConstraints);
        this.YesNoOpcodeQuestion("Play", 65, gridBagConstraints);
        this.TextRow("   Supported Operands?", "(0x05 - 0x25)", this.playOperands, gridBagConstraints);
        this.YesNoSectionQuestion("Tuner Control", this.tunerControl, gridBagConstraints, false);
        this.YesNoOpcodeQuestion("Give Tuner Device Status", 8, gridBagConstraints);
        this.GenericYesNoTripleQuestion("   Supported operands?", "On", "Off", "Once", this.tunerDeviceStatusOn, this.tunerDeviceStatusOff, this.tunerDeviceStatusOnce, gridBagConstraints);
        this.YesNoOpcodeQuestion("Select Digital Service", 146, gridBagConstraints);
        this.YesNoOpcodeQuestion("Select Analogue Service", 147, gridBagConstraints);
        this.YesNoOpcodeQuestion("Tuner Device Status", 7, gridBagConstraints);
        this.YesNoOpcodeQuestion("Tuner Step Decrement", 6, gridBagConstraints);
        this.YesNoOpcodeQuestion("Tuner Step Increment", 5, gridBagConstraints);
        this.YesNoSectionQuestion("Vendor Specific", this.vendorSpecific, gridBagConstraints, false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)new QDLabel("Vendor ID used by DUT"), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 13;
        this.add((Component)new QDLabel("24 bit IEEE ID"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)new QDLabel("Vendor ID that is not the DUT's"), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 13;
        this.add((Component)new QDLabel("24 bit IEEE ID"), gridBagConstraints);
        --gridBagConstraints.gridy;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 6;
        this.add((Component)this.vendorID, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.badVendorID.setText("0007AA");
        this.add((Component)this.badVendorID, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        this.YesNoOpcodeQuestion("Device Vendor ID", 135, gridBagConstraints);
        this.YesNoOpcodeQuestion("Give Device Vendor ID", 140, gridBagConstraints);
        this.YesNoOpcodeQuestion("Vendor Command", 137, gridBagConstraints);
        this.YesNoQuestion("<HTML>&nbsp;&nbsp;&nbsp;Can the DUT send a <Vendor Command> to a device whose<br>&nbsp;&nbsp;&nbsp;Vendor ID is different from the DUT's?</HTML>", this.sendsVendorCommandsToOtherVendors, gridBagConstraints);
        this.YesNoOpcodeQuestion("Vendor Command With ID", 160, gridBagConstraints);
        this.YesNoOpcodeQuestion("Vendor Remote Button Down", 138, gridBagConstraints);
        this.YesNoOpcodeQuestion("Vendor Remote Button Up", 139, gridBagConstraints);
        this.YesNoSectionQuestion("OSD Display", this.osdDisplay, gridBagConstraints, false);
        this.YesNoOpcodeQuestion("Set OSD String", 100, gridBagConstraints);
        this.YesNoSectionQuestion("Device OSD Transfer", this.deviceOsdTransfer, gridBagConstraints, false);
        this.YesNoOpcodeQuestion("Give OSD Name", 70, gridBagConstraints);
        this.YesNoOpcodeQuestion("Set OSD Name", 71, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)new QDLabel("   Device OSD Name"), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 13;
        this.add((Component)new QDLabel("(up to 14 ASCII)"), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 6;
        this.osdName.setColumns(16);
        this.add((Component)this.osdName, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.YesNoSectionQuestion("Device Menu Control", this.deviceMenuControl, gridBagConstraints, false);
        this.YesNoOpcodeQuestion("Menu Request", 141, gridBagConstraints);
        this.YesNoOpcodeQuestion("Menu Status", 142, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.anchor = 17;
        this.add((Component)new QDLabel("<HTML>&nbsp;&nbsp;&nbsp;What device(s) can the<br>&nbsp;&nbsp;&nbsp;DUT send Remote Control<br>&nbsp;&nbsp;&nbsp;Passthrough to on the state of<br>&nbsp;&nbsp;&nbsp;Device Menu Active?</HTML>"), gridBagConstraints);
        gridBagConstraints.gridx = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 4;
        this.add((Component)new QDLabel("<HTML>Select the device if<br>the DUT can send RC<br>passthrough to it<br>after receiving<br>&lt;Menu Status&gt;<br>[\"Activated\"]</HTML>"), gridBagConstraints);
        for (n = 0; n < 4; ++n) {
            this.rcPassActiveOperands[n].setToolTipText(operandToolTip);
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets.top = 15;
        this.AddCheckbox("Recording Device?", this.supportRCPassToRecDevOnActive, gridBagConstraints);
        gridBagConstraints.insets.top = 3;
        this.AddCheckbox("Playback Device?", this.supportRCPassToPlayDevOnActive, gridBagConstraints);
        this.AddCheckbox("Tuner?", this.supportRCPassToTunerOnActive, gridBagConstraints);
        this.AddCheckbox("Audio System?", this.supportRCPassToAudioSysOnActive, gridBagConstraints);
        this.TextRow("   Supported IDs to send to Recording Devices?", "(0x00 - 0x75)", this.rcPassActiveOperands[0], gridBagConstraints);
        this.TextRow("   Supported IDs to send to Playback Devices?", "(0x00 - 0x75)", this.rcPassActiveOperands[1], gridBagConstraints);
        this.TextRow("   Supported IDs to send to Tuners?", "(0x00 - 0x75)", this.rcPassActiveOperands[2], gridBagConstraints);
        this.TextRow("   Supported IDs to send to Audio Systems?", "(0x00 - 0x75)", this.rcPassActiveOperands[3], gridBagConstraints);
        this.YesNoSectionQuestion("Remote Control Passthrough", this.rcPassthrough, gridBagConstraints, false);
        this.YesNoOpcodeQuestion("User Control Pressed", 68, gridBagConstraints);
        this.YesNoOpcodeQuestion("User Control Released", 69, gridBagConstraints);
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)new QDLabel("<HTML>&nbsp;&nbsp;&nbsp;What device(s) can the<br>&nbsp;&nbsp;&nbsp;DUT select as the target device for<br>&nbsp;&nbsp;&nbsp;Remote Control Passthrough?</HTML>"), gridBagConstraints);
        gridBagConstraints.gridx = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 4;
        this.add((Component)new QDLabel("<HTML>Select the device if<br>the DUT can select<br>as the target device<br>for RC passthrough<br>(e.g. [\"Record\"] for<br>Recording Device)</HTML>"), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        for (n = 0; n < 6; ++n) {
            this.rcPassOperands[n].setToolTipText(operandToolTip);
        }
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets.top = 15;
        this.AddCheckbox("TV/Display?", this.supportRCPassToTV, gridBagConstraints);
        gridBagConstraints.insets.top = 3;
        this.AddCheckbox("Recording Device?", this.supportRCPassToRecDev, gridBagConstraints);
        this.AddCheckbox("Playback Device?", this.supportRCPassToPlayDev, gridBagConstraints);
        this.AddCheckbox("Tuner?", this.supportRCPassToTuner, gridBagConstraints);
        this.AddCheckbox("Audio System?", this.supportRCPassToAudioSys, gridBagConstraints);
        this.TextRow("   Supported IDs to send to TVs?", "(0x00 - 0x75)", this.rcPassOperands[0], gridBagConstraints);
        this.TextRow("   Supported IDs to send to Recording Devices?", "(0x00 - 0x75)", this.rcPassOperands[1], gridBagConstraints);
        this.TextRow("   Supported IDs to send to Playback Devices?", "(0x00 - 0x75)", this.rcPassOperands[2], gridBagConstraints);
        this.TextRow("   Supported IDs to send to Tuners?", "(0x00 - 0x75)", this.rcPassOperands[3], gridBagConstraints);
        this.TextRow("   Supported IDs to send to Audio Systems?", "(0x00 - 0x75)", this.rcPassOperands[4], gridBagConstraints);
        this.TextRow("   Supported IDs as follower?", "(0x00 - 0x75)", this.rcPassOperands[5], gridBagConstraints);
        this.YesNoSectionQuestion("Power Status", this.powerStatus, gridBagConstraints, true);
        this.YesNoOpcodeQuestion("Give Device Power Status", 143, gridBagConstraints);
        this.GenericYesNoDoubleQuestion("<Report Power Status>[\"On\"]", "Initiator?", "Follower?", this.initiatorOpcodes[144], this.followerOpcodes[144], gridBagConstraints);
        this.GenericYesNoDoubleQuestion("<Report Power Status>[\"Standby\"]", "Initiator?", "Follower?", this.supportReportPowerStandbyInit, this.supportReportPowerStandbyFollow, gridBagConstraints);
        this.initiatorOpcodes[144].setSelected(true);
        this.supportReportPowerStandbyInit.setSelected(true);
        this.YesNoSectionQuestion("Feature Abort", this.featureAbort, gridBagConstraints, true);
        this.YesNoOpcodeQuestion("Feature Abort", 0, gridBagConstraints);
        this.YesNoOpcodeQuestion("Abort", 255, gridBagConstraints);
        this.initiatorOpcodes[0].setSelected(true);
        this.followerOpcodes[0].setSelected(true);
        this.initiatorOpcodes[0].setEnabled(false);
        this.followerOpcodes[0].setEnabled(false);
        this.initiatorOpcodes[255].setSelected(false);
        this.initiatorOpcodes[255].setEnabled(false);
        this.YesNoSectionQuestion("System Audio Control", this.systemAudioControl, gridBagConstraints, false);
        this.YesNoOpcodeQuestion("Give Audio Status", 113, gridBagConstraints);
        this.YesNoOpcodeQuestion("Give System Audio Mode Status", 125, gridBagConstraints);
        this.YesNoOpcodeQuestion("Report Audio Status", 122, gridBagConstraints);
        this.YesNoOpcodeQuestion("Set System Audio Mode", 114, gridBagConstraints);
        this.YesNoOpcodeQuestion("System Audio Mode Request", 112, gridBagConstraints);
        this.YesNoOpcodeQuestion("System Audio Mode Status", 126, gridBagConstraints);
        this.YesNoSectionQuestion("Audio Rate Control", this.audioRateControl, gridBagConstraints, false);
        this.GenericYesNoDoubleQuestion("Supported control ranges by the DUT", "Wide?", "Narrow?", this.wideAudioRateControl, this.narrowAudioRateControl, gridBagConstraints);
        this.YesNoOpcodeQuestion("Set Audio Rate", 154, gridBagConstraints);
    }

    private void AddCheckbox(String string, QDCheckBox qDCheckBox, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 3;
        this.add((Component)new QDLabel(string), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 5;
        this.add((Component)qDCheckBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }

    private void YesNoQuestion(String string, QDCheckBox qDCheckBox, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)new QDLabel(string), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)qDCheckBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }

    private void YesNoSectionQuestion(String string, QDCheckBox qDCheckBox, GridBagConstraints gridBagConstraints, boolean bl) {
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top = 30;
        QDLabel qDLabel = new QDLabel(string);
        qDLabel.setFont(new Font("SansSerif", 3, 14));
        this.add((Component)qDLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.AddCheckbox("Support?", qDCheckBox, gridBagConstraints);
        if (bl) {
            qDCheckBox.setSelected(true);
            qDCheckBox.setEnabled(false);
        }
        gridBagConstraints.insets.top = 3;
        ++gridBagConstraints.gridy;
    }

    private void YesNoOpcodeQuestion(String string, int n, GridBagConstraints gridBagConstraints) {
        this.GenericYesNoDoubleQuestion("<" + string + ">", "Initiator?", "Follower?", this.initiatorOpcodes[n], this.followerOpcodes[n], gridBagConstraints);
    }

    private void GenericYesNoDoubleQuestion(String string, String string2, String string3, QDCheckBox qDCheckBox, QDCheckBox qDCheckBox2, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)new QDLabel(string), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 5;
        this.add((Component)new QDLabel(string2), gridBagConstraints);
        gridBagConstraints.gridx += 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)qDCheckBox, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        ++gridBagConstraints.gridx;
        this.add((Component)new QDLabel(string3), gridBagConstraints);
        gridBagConstraints.gridx += 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)qDCheckBox2, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }

    private void GenericYesNoTripleQuestion(String string, String string2, String string3, String string4, QDCheckBox qDCheckBox, QDCheckBox qDCheckBox2, QDCheckBox qDCheckBox3, GridBagConstraints gridBagConstraints) {
        this.GenericYesNoDoubleQuestion(string, string3, string4, qDCheckBox2, qDCheckBox3, gridBagConstraints);
        --gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 3;
        this.add((Component)new QDLabel(string2), gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.anchor = 17;
        this.add((Component)qDCheckBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }

    private void AddTunerInfo(String string, QDCheckBox qDCheckBox, JFormattedTextField[] jFormattedTextFieldArray, String string2, int n, GridBagConstraints gridBagConstraints) {
        this.YesNoQuestion(string, qDCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridheight = n;
        this.add((Component)new QDLabel(string2), gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridheight = 1;
        for (int i = 0; i < n; ++i) {
            this.add((Component)jFormattedTextFieldArray[i], gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
    }

    private void TextRow(String string, String string2, JTextField jTextField, GridBagConstraints gridBagConstraints) {
        jTextField.setColumns(16);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)new QDLabel(string), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 13;
        this.add((Component)new QDLabel(string2), gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.anchor = 17;
        this.add((Component)jTextField, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
    }

    public void SendCDFEntries(DbNode dbNode) {
        int n;
        int n2;
        dbNode.addElement("CECVersion", this.cecVersionBox.getSelectedIndex());
        DbNode dbNode2 = dbNode.createChild("DigitalTuner");
        dbNode2.addElement("Support", this.digitalTunerBox.isSelected());
        if (this.digitalTunerBox.isSelected()) {
            for (n2 = 0; n2 < this.digitalTuner.length; ++n2) {
                dbNode2.addElement("TunerID", this.digitalTuner[n2].getText().trim());
            }
        }
        dbNode2 = dbNode.createChild("AnalogTuner");
        dbNode2.addElement("Support", this.analogTunerBox.isSelected());
        if (this.analogTunerBox.isSelected()) {
            for (n2 = 0; n2 < this.digitalTuner.length; ++n2) {
                dbNode2.addElement("TunerID", this.analogTuner[n2].getText().trim());
            }
        }
        dbNode2 = dbNode.createChild("Languages");
        String[] stringArray = this.supportedLanguages.getText().trim().split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].trim().length() != 3) continue;
            dbNode2.addElement("Code", stringArray[i].trim());
        }
        boolean[] blArray = new boolean[4];
        boolean[] blArray2 = new boolean[15];
        boolean[] blArray3 = new boolean[33];
        if (!CECComplianceMain.ParseRange(this.deckControlOperands.getText(), blArray, 1, 4)) {
            // empty if block
        }
        if (!CECComplianceMain.ParseRange(this.deckStatusOperands.getText(), blArray2, 17, 31)) {
            // empty if block
        }
        if (!CECComplianceMain.ParseRange(this.playOperands.getText(), blArray3, 5, 37)) {
            // empty if block
        }
        dbNode2 = dbNode.createChild("DeckCtrl");
        dbNode2.addElement("Support", this.deckControl.isSelected());
        for (n = 0; n < blArray.length; ++n) {
            if (!blArray[n]) continue;
            dbNode2.addElement("Op", n + 1);
        }
        dbNode2 = dbNode.createChild("DeckStatus");
        dbNode2.addElement("ParamOn", this.deckStatusOn.isSelected());
        dbNode2.addElement("ParamOff", this.deckStatusOff.isSelected());
        dbNode2.addElement("ParamOnce", this.deckStatusOnce.isSelected());
        for (n = 0; n < blArray2.length; ++n) {
            if (!blArray2[n]) continue;
            dbNode2.addElement("Op", n + 17);
        }
        dbNode2 = dbNode.createChild("Play");
        for (n = 0; n < blArray3.length; ++n) {
            if (!blArray3[n]) continue;
            dbNode2.addElement("Op", n + 5);
        }
        dbNode2 = dbNode.createChild("RCPassThruActive");
        DbNode dbNode3 = dbNode2.createChild("RecDev");
        this.AddRCPassThrough(this.supportRCPassToRecDevOnActive.isSelected(), this.rcPassActiveOperands[0].getText(), dbNode3);
        dbNode3 = dbNode2.createChild("Player");
        this.AddRCPassThrough(this.supportRCPassToPlayDevOnActive.isSelected(), this.rcPassActiveOperands[1].getText(), dbNode3);
        dbNode3 = dbNode2.createChild("Tuner");
        this.AddRCPassThrough(this.supportRCPassToTunerOnActive.isSelected(), this.rcPassActiveOperands[2].getText(), dbNode3);
        dbNode3 = dbNode2.createChild("AudioSys");
        this.AddRCPassThrough(this.supportRCPassToAudioSysOnActive.isSelected(), this.rcPassActiveOperands[3].getText(), dbNode3);
        dbNode2 = dbNode.createChild("RCPassThru");
        dbNode2.addElement("Supported", this.rcPassthrough.isSelected());
        dbNode3 = dbNode2.createChild("TV");
        this.AddRCPassThrough(this.supportRCPassToTV.isSelected(), this.rcPassOperands[0].getText(), dbNode3);
        dbNode3 = dbNode2.createChild("RecDev");
        this.AddRCPassThrough(this.supportRCPassToRecDev.isSelected(), this.rcPassOperands[1].getText(), dbNode3);
        dbNode3 = dbNode2.createChild("Player");
        this.AddRCPassThrough(this.supportRCPassToPlayDev.isSelected(), this.rcPassOperands[2].getText(), dbNode3);
        dbNode3 = dbNode2.createChild("Tuner");
        this.AddRCPassThrough(this.supportRCPassToTuner.isSelected(), this.rcPassOperands[3].getText(), dbNode3);
        dbNode3 = dbNode2.createChild("AudioSys");
        this.AddRCPassThrough(this.supportRCPassToAudioSys.isSelected(), this.rcPassOperands[4].getText(), dbNode3);
        dbNode3 = dbNode2.createChild("Follower");
        this.AddRCPassThrough(true, this.rcPassOperands[5].getText(), dbNode3);
        dbNode.addElement("OutOfStandby", this.dutOutOfStandby.isSelected());
        dbNode.addElement("TwoConsecutive", this.twoConsecutiveMsgs.isSelected());
        dbNode.addElement("OneTouchPlay", this.oneTouchPlay.isSelected());
        dbNode.addElement("OneTouchRec", this.oneTouchRecord.isSelected());
        dbNode.addElement("InternalSrc", this.hasInternalSource.isSelected());
        dbNode.addElement("TextMode", this.hasTextMode.isSelected());
        dbNode.addElement("RoutingCtrl", this.routingControl.isSelected());
        dbNode2 = dbNode.createChild("Standby");
        dbNode2.addElement("Support", this.standbyFeature.isSelected());
        dbNode2.addElement("DirectInit", this.standbyInitiator[0].isSelected());
        dbNode2.addElement("DirectFollow", this.standbyFollower[0].isSelected());
        dbNode2.addElement("BroadcastInit", this.standbyInitiator[1].isSelected());
        dbNode2.addElement("BroadcastFollow", this.standbyFollower[1].isSelected());
        dbNode.addElement("TimerProg", this.timerProgramming.isSelected());
        dbNode.addElement("SystemInfo", this.systemInformation.isSelected());
        dbNode2 = dbNode.createChild("TunerDevStatus");
        dbNode2.addElement("ParamOn", this.tunerDeviceStatusOn.isSelected());
        dbNode2.addElement("ParamOff", this.tunerDeviceStatusOff.isSelected());
        dbNode2.addElement("ParamOnce", this.tunerDeviceStatusOnce.isSelected());
        dbNode2 = dbNode.createChild("AudioRateCtrl");
        dbNode2.addElement("Support", this.audioRateControl.isSelected());
        dbNode2.addElement("Narrow", this.narrowAudioRateControl.isSelected());
        dbNode2.addElement("Wide", this.wideAudioRateControl.isSelected());
        dbNode2 = dbNode.createChild("VendorSpec");
        dbNode2.addElement("Support", this.vendorSpecific.isSelected());
        dbNode2.addElement("VendorID", this.vendorID.getText().trim());
        dbNode2.addElement("BadVendorID", this.badVendorID.getText().trim());
        dbNode2.addElement("VendorToOthers", this.sendsVendorCommandsToOtherVendors.isSelected());
        dbNode2 = dbNode.createChild("Polling");
        dbNode2.addElement("Init", this.pollingInitiator.isSelected());
        dbNode2.addElement("Follow", this.pollingFollower.isSelected());
        dbNode2 = dbNode.createChild("Opcodes");
        dbNode3 = dbNode2.createChild("Init");
        for (n = 0; n < 256; ++n) {
            if (!this.initiatorOpcodes[n].isSelected()) continue;
            dbNode3.addElement("Op", n);
        }
        dbNode3 = dbNode2.createChild("Follow");
        for (n = 0; n < 256; ++n) {
            if (!this.followerOpcodes[n].isSelected()) continue;
            dbNode3.addElement("Op", n);
        }
        dbNode2 = dbNode.createChild("RecordOn");
        dbNode3 = dbNode2.createChild("Init");
        for (n = 0; n < 5; ++n) {
            if (!this.recordOnInitiator[n].isSelected()) continue;
            dbNode3.addElement("Param", n);
        }
        dbNode3 = dbNode2.createChild("Follow");
        for (n = 0; n < 5; ++n) {
            if (!this.recordOnFollower[n].isSelected()) continue;
            dbNode3.addElement("Param", n);
        }
        dbNode.addElement("TunerCtrl", this.tunerControl.isSelected());
        dbNode.addElement("OSDDisplay", this.osdDisplay.isSelected());
        dbNode.addElement("OSDName", this.osdName.getText().trim());
        dbNode.addElement("DevOSDTrans", this.deviceOsdTransfer.isSelected());
        dbNode.addElement("DevMenuCtrl", this.deviceMenuControl.isSelected());
        dbNode.addElement("PowerStatus", this.powerStatus.isSelected());
        dbNode.addElement("FeatureAbort", this.featureAbort.isSelected());
        dbNode.addElement("SysAudCtrl", this.systemAudioControl.isSelected());
        dbNode2 = dbNode.createChild("ExtTimer");
        dbNode2.addElement("Plug", this.externalPlugNum.getSelectedIndex());
        dbNode2.addElement("PA", this.externalPA.getText().trim());
        dbNode2.addElement("PlugInit", this.extTimerInitiator[0].isSelected());
        dbNode2.addElement("PlugFollow", this.extTimerFollower[0].isSelected());
        dbNode2.addElement("PAInit", this.extTimerInitiator[1].isSelected());
        dbNode2.addElement("PAFollow", this.extTimerFollower[1].isSelected());
        dbNode.addElement("TimerDay", this.timerDay.getSelectedIndex() + 1);
        dbNode.addElement("TimerMonth", this.timerMonth.getSelectedIndex() + 1);
        dbNode.addElement("ReptPwrStandbyInit", this.supportReportPowerStandbyInit.isSelected());
        dbNode.addElement("ReptPwrStandbyFollow", this.supportReportPowerStandbyFollow.isSelected());
        dbNode.addElement("OutOfStandbyMethod", this.outOfStandbyBox.getSelectedIndex());
    }

    public void GetCDFEntries(DbNode dbNode) {
        String string;
        DbNode dbNode2;
        int n;
        this.cecVersionBox.setSelectedIndex(dbNode.getIntElement("CECVersion"));
        DbNode dbNode3 = dbNode.getNode("DigitalTuner");
        int n2 = 0;
        for (n = 0; n < this.digitalTuner.length; ++n) {
            this.digitalTuner[n].setText("00 00 00 00 00 00 00");
        }
        for (n = 0; n < dbNode3.getNodeCount(); ++n) {
            dbNode2 = dbNode3.getNode(n);
            string = dbNode2.getName();
            if (string.equalsIgnoreCase("Support")) {
                this.digitalTunerBox.setSelected(dbNode2.getBoolValue());
                continue;
            }
            if (!string.equalsIgnoreCase("TunerID") || n2 >= this.digitalTuner.length) continue;
            this.digitalTuner[n2].setText(dbNode2.getValue());
            ++n2;
        }
        n2 = 0;
        dbNode3 = dbNode.getNode("AnalogTuner");
        for (n = 0; n < this.analogTuner.length; ++n) {
            this.analogTuner[n].setText("00 00 00 00");
        }
        for (n = 0; n < dbNode3.getNodeCount(); ++n) {
            dbNode2 = dbNode3.getNode(n);
            string = dbNode2.getName();
            if (string.equalsIgnoreCase("Support")) {
                this.analogTunerBox.setSelected(dbNode2.getBoolValue());
                continue;
            }
            if (!string.equalsIgnoreCase("TunerID") || n2 >= this.analogTuner.length) continue;
            this.analogTuner[n2].setText(dbNode2.getValue());
            ++n2;
        }
        dbNode3 = dbNode.getNode("Languages");
        this.supportedLanguages.setText("");
        for (n = 0; n < dbNode3.getNodeCount(); ++n) {
            dbNode2 = dbNode3.getNode(n);
            string = dbNode2.getName();
            if (!string.equalsIgnoreCase("Code")) continue;
            this.AddStringToField(this.supportedLanguages, dbNode2.getValue());
        }
        dbNode3 = dbNode.getNode("DeckCtrl");
        this.deckControl.setSelected(dbNode3.getBoolElement("Support"));
        this.GetOperands(dbNode3, this.deckControlOperands);
        dbNode3 = dbNode.getNode("DeckStatus");
        this.deckStatusOn.setSelected(dbNode3.getBoolElement("ParamOn"));
        this.deckStatusOff.setSelected(dbNode3.getBoolElement("ParamOff"));
        this.deckStatusOnce.setSelected(dbNode3.getBoolElement("ParamOnce"));
        this.GetOperands(dbNode3, this.deckStatusOperands);
        dbNode3 = dbNode.getNode("Play");
        this.GetOperands(dbNode3, this.playOperands);
        dbNode3 = dbNode.getNode("RCPassThruActive");
        DbNode dbNode4 = dbNode3.getNode("RecDev");
        this.GetRCPassThrough(dbNode4, this.supportRCPassToRecDevOnActive, this.rcPassActiveOperands[0]);
        dbNode4 = dbNode3.getNode("Player");
        this.GetRCPassThrough(dbNode4, this.supportRCPassToPlayDevOnActive, this.rcPassActiveOperands[1]);
        dbNode4 = dbNode3.getNode("Tuner");
        this.GetRCPassThrough(dbNode4, this.supportRCPassToTunerOnActive, this.rcPassActiveOperands[2]);
        dbNode4 = dbNode3.getNode("AudioSys");
        this.GetRCPassThrough(dbNode4, this.supportRCPassToAudioSysOnActive, this.rcPassActiveOperands[3]);
        dbNode3 = dbNode.getNode("RCPassThru");
        this.rcPassthrough.setSelected(dbNode3.getBoolElement("Supported"));
        dbNode4 = dbNode3.getNode("TV");
        this.GetRCPassThrough(dbNode4, this.supportRCPassToTV, this.rcPassOperands[0]);
        dbNode4 = dbNode3.getNode("RecDev");
        this.GetRCPassThrough(dbNode4, this.supportRCPassToRecDev, this.rcPassOperands[1]);
        dbNode4 = dbNode3.getNode("Player");
        this.GetRCPassThrough(dbNode4, this.supportRCPassToPlayDev, this.rcPassOperands[2]);
        dbNode4 = dbNode3.getNode("Tuner");
        this.GetRCPassThrough(dbNode4, this.supportRCPassToTuner, this.rcPassOperands[3]);
        dbNode4 = dbNode3.getNode("AudioSys");
        this.GetRCPassThrough(dbNode4, this.supportRCPassToAudioSys, this.rcPassOperands[4]);
        dbNode4 = dbNode3.getNode("Follower");
        this.GetRCPassThrough(dbNode4, null, this.rcPassOperands[5]);
        this.dutOutOfStandby.setSelected(dbNode.getBoolElement("OutOfStandby"));
        this.twoConsecutiveMsgs.setSelected(dbNode.getBoolElement("TwoConsecutive"));
        this.oneTouchPlay.setSelected(dbNode.getBoolElement("OneTouchPlay"));
        this.oneTouchRecord.setSelected(dbNode.getBoolElement("OneTouchRec"));
        this.hasInternalSource.setSelected(dbNode.getBoolElement("InternalSrc"));
        this.hasTextMode.setSelected(dbNode.getBoolElement("TextMode"));
        this.routingControl.setSelected(dbNode.getBoolElement("RoutingCtrl"));
        dbNode3 = dbNode.getNode("Standby");
        this.standbyFeature.setSelected(dbNode3.getBoolElement("Support"));
        this.standbyInitiator[0].setSelected(dbNode3.getBoolElement("DirectInit"));
        this.standbyFollower[0].setSelected(dbNode3.getBoolElement("DirectFollow"));
        this.standbyInitiator[1].setSelected(dbNode3.getBoolElement("BroadcastInit"));
        this.standbyFollower[1].setSelected(dbNode3.getBoolElement("BroadcastFollow"));
        this.timerProgramming.setSelected(dbNode.getBoolElement("TimerProg"));
        this.systemInformation.setSelected(dbNode.getBoolElement("SystemInfo"));
        dbNode3 = dbNode.getNode("TunerDevStatus");
        this.tunerDeviceStatusOn.setSelected(dbNode3.getBoolElement("ParamOn"));
        this.tunerDeviceStatusOff.setSelected(dbNode3.getBoolElement("ParamOff"));
        this.tunerDeviceStatusOnce.setSelected(dbNode3.getBoolElement("ParamOnce"));
        dbNode3 = dbNode.getNode("TunerDevStatus");
        this.audioRateControl.setSelected(dbNode3.getBoolElement("Support"));
        this.narrowAudioRateControl.setSelected(dbNode3.getBoolElement("Narrow"));
        this.wideAudioRateControl.setSelected(dbNode3.getBoolElement("Wide"));
        dbNode3 = dbNode.getNode("VendorSpec");
        this.vendorSpecific.setSelected(dbNode3.getBoolElement("Support"));
        this.vendorID.setText(dbNode3.getElement("VendorID"));
        this.badVendorID.setText(dbNode3.getElement("BadVendorID"));
        this.sendsVendorCommandsToOtherVendors.setSelected(dbNode3.getBoolElement("VendorToOthers"));
        dbNode3 = dbNode.getNode("Polling");
        this.pollingInitiator.setSelected(dbNode3.getBoolElement("Init"));
        this.pollingFollower.setSelected(dbNode3.getBoolElement("Follow"));
        dbNode3 = dbNode.getNode("Opcodes");
        dbNode4 = dbNode3.getNode("Init");
        for (n = 0; n < this.initiatorOpcodes.length; ++n) {
            this.initiatorOpcodes[n].setSelected(false);
            this.followerOpcodes[n].setSelected(false);
        }
        for (n = 0; n < dbNode4.getNodeCount(); ++n) {
            dbNode2 = dbNode4.getNode(n);
            string = dbNode2.getName();
            if (!string.equalsIgnoreCase("Op")) continue;
            this.initiatorOpcodes[dbNode2.getIntValue()].setSelected(true);
        }
        dbNode4 = dbNode3.getNode("Follow");
        for (n = 0; n < dbNode4.getNodeCount(); ++n) {
            dbNode2 = dbNode4.getNode(n);
            string = dbNode2.getName();
            if (!string.equalsIgnoreCase("Op")) continue;
            this.followerOpcodes[dbNode2.getIntValue()].setSelected(true);
        }
        dbNode3 = dbNode.getNode("RecordOn");
        dbNode4 = dbNode3.getNode("Init");
        for (n = 0; n < this.recordOnInitiator.length; ++n) {
            this.recordOnInitiator[n].setSelected(false);
            this.recordOnFollower[n].setSelected(false);
        }
        for (n = 0; n < dbNode4.getNodeCount(); ++n) {
            dbNode2 = dbNode4.getNode(n);
            string = dbNode2.getName();
            if (!string.equalsIgnoreCase("Param")) continue;
            this.recordOnInitiator[dbNode2.getIntValue()].setSelected(true);
        }
        dbNode4 = dbNode3.getNode("Follow");
        for (n = 0; n < dbNode4.getNodeCount(); ++n) {
            dbNode2 = dbNode4.getNode(n);
            string = dbNode2.getName();
            if (!string.equalsIgnoreCase("Param")) continue;
            this.recordOnFollower[dbNode2.getIntValue()].setSelected(true);
        }
        this.tunerControl.setSelected(dbNode.getBoolElement("TunerCtrl"));
        this.osdDisplay.setSelected(dbNode.getBoolElement("OSDDisplay"));
        this.osdName.setText(dbNode.getElement("OSDName"));
        this.deviceOsdTransfer.setSelected(dbNode.getBoolElement("DevOSDTrans"));
        this.deviceMenuControl.setSelected(dbNode.getBoolElement("DevMenuCtrl"));
        this.powerStatus.setSelected(dbNode.getBoolElement("PowerStatus"));
        this.featureAbort.setSelected(dbNode.getBoolElement("FeatureAbort"));
        this.systemAudioControl.setSelected(dbNode.getBoolElement("SysAudCtrl"));
        dbNode3 = dbNode.getNode("ExtTimer");
        this.externalPlugNum.setSelectedIndex(dbNode3.getIntElement("Plug"));
        this.externalPA.setText(dbNode3.getElement("PA"));
        this.extTimerInitiator[0].setSelected(dbNode3.getBoolElement("PlugInit"));
        this.extTimerFollower[0].setSelected(dbNode3.getBoolElement("PlugFollow"));
        this.extTimerInitiator[1].setSelected(dbNode3.getBoolElement("PAInit"));
        this.extTimerFollower[1].setSelected(dbNode3.getBoolElement("PAFollow"));
        this.timerDay.setSelectedIndex(dbNode.getIntElement("TimerDay") - 1);
        this.timerMonth.setSelectedIndex(dbNode.getIntElement("TimerMonth") - 1);
        this.supportReportPowerStandbyInit.setSelected(dbNode.getBoolElement("ReptPwrStandbyInit"));
        this.supportReportPowerStandbyFollow.setSelected(dbNode.getBoolElement("ReptPwrStandbyFollow"));
        this.outOfStandbyBox.setSelectedIndex(dbNode.getIntElement("OutOfStandbyMethod"));
    }

    public void AddStringToField(JTextField jTextField, String string) {
        if (jTextField.getText().length() == 0) {
            jTextField.setText(string);
        } else {
            jTextField.setText(jTextField.getText() + "," + string);
        }
    }

    public void GetOperands(DbNode dbNode, JTextField jTextField) {
        jTextField.setText("");
        for (int i = 0; i < dbNode.getNodeCount(); ++i) {
            DbNode dbNode2 = dbNode.getNode(i);
            String string = dbNode2.getName();
            if (!string.equalsIgnoreCase("Op")) continue;
            String string2 = "0x" + Integer.toHexString(dbNode2.getIntValue());
            this.AddStringToField(jTextField, string2);
        }
    }

    public void AddRCPassThrough(boolean bl, String string, DbNode dbNode) {
        boolean[] blArray = new boolean[118];
        dbNode.addElement("Support", bl);
        if (bl) {
            if (!CECComplianceMain.ParseRange(string, blArray, 0, 117)) {
                // empty if block
            }
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                dbNode.addElement("Op", i);
            }
        }
    }

    public void GetRCPassThrough(DbNode dbNode, QDCheckBox qDCheckBox, JTextField jTextField) {
        boolean bl = dbNode.getBoolElement("Support");
        if (qDCheckBox != null) {
            qDCheckBox.setSelected(bl);
        }
        if (bl) {
            this.GetOperands(dbNode, jTextField);
        }
    }

    public void LoadFromCSV(Scanner scanner) {
        try {
            int n;
            this.SkipLines(scanner, 10);
            this.SetCheckbox(scanner, 5, this.digitalTunerBox);
            String[] stringArray = scanner.nextLine().split(",");
            stringArray = scanner.nextLine().split(",");
            this.SetCheckbox(scanner, 5, this.analogTunerBox);
            stringArray = scanner.nextLine().split(",");
            stringArray = scanner.nextLine().split(",");
            stringArray = scanner.nextLine().split(",");
            this.SetCheckbox(scanner, 5, this.dutOutOfStandby);
            this.SkipLines(scanner, 2);
            this.SetCheckbox(scanner, 5, this.twoConsecutiveMsgs);
            this.SkipLines(scanner, 2);
            this.SetCheckbox(scanner, 5, this.hasInternalSource);
            this.SetCheckbox(scanner, 5, this.hasTextMode);
            scanner.nextLine();
            this.AddOpcode(scanner, 130);
            this.SkipLines(scanner, 2);
            this.AddOpcode(scanner, 4);
            this.SkipLines(scanner, 2);
            this.AddOpcode(scanner, 13);
            this.SkipLines(scanner, 3);
            this.AddOpcode(scanner, 133);
            this.SkipLines(scanner, 2);
            this.AddOpcode(scanner, 128);
            this.SkipLines(scanner, 4);
            this.AddOpcode(scanner, 129);
            this.SkipLines(scanner, 2);
            this.AddOpcode(scanner, 134);
            this.SkipLines(scanner, 3);
            this.AddOpcode(scanner, 157);
            this.SkipLines(scanner, 2);
            this.SetCheckbox(scanner, 5, this.standbyFeature);
            stringArray = scanner.nextLine().split(",");
            this.SetCheckbox(stringArray, 7, this.standbyInitiator[0]);
            this.SetCheckbox(stringArray, 10, this.standbyFollower[0]);
            this.SkipLines(scanner, 2);
            stringArray = scanner.nextLine().split(",");
            this.SetCheckbox(stringArray, 7, this.standbyInitiator[1]);
            this.SetCheckbox(stringArray, 10, this.standbyFollower[1]);
            this.SkipLines(scanner, 2);
            this.SetCheckbox(scanner, 5, this.oneTouchRecord);
            this.AddOpcode(scanner, 11);
            this.SkipLines(scanner, 2);
            stringArray = scanner.nextLine().split(",");
            this.SetCheckbox(stringArray, 7, this.recordOnInitiator[0]);
            this.SetCheckbox(stringArray, 10, this.recordOnFollower[0]);
            this.SkipLines(scanner, 4);
            stringArray = scanner.nextLine().split(",");
            this.SetCheckbox(stringArray, 7, this.recordOnInitiator[1]);
            this.SetCheckbox(stringArray, 10, this.recordOnFollower[1]);
            this.SkipLines(scanner, 4);
            stringArray = scanner.nextLine().split(",");
            this.SetCheckbox(stringArray, 7, this.recordOnInitiator[2]);
            this.SetCheckbox(stringArray, 10, this.recordOnFollower[2]);
            this.SkipLines(scanner, 4);
            stringArray = scanner.nextLine().split(",");
            this.SetCheckbox(stringArray, 7, this.recordOnInitiator[3]);
            this.SetCheckbox(stringArray, 10, this.recordOnFollower[3]);
            this.SkipLines(scanner, 3);
            stringArray = scanner.nextLine().split(",");
            this.SetCheckbox(stringArray, 7, this.recordOnInitiator[4]);
            this.SetCheckbox(stringArray, 10, this.recordOnFollower[4]);
            this.SkipLines(scanner, 3);
            this.AddOpcode(scanner, 10);
            this.AddOpcode(scanner, 15);
            this.SkipLines(scanner, 2);
            this.SetCheckbox(scanner, 5, this.timerProgramming);
            this.AddOpcode(scanner, 51);
            this.SkipLines(scanner, 2);
            this.AddOpcode(scanner, 153);
            this.SkipLines(scanner, 2);
            this.AddOpcode(scanner, 161);
            this.SkipLines(scanner, 2);
            this.AddOpcode(scanner, 52);
            this.SkipLines(scanner, 2);
            this.AddOpcode(scanner, 151);
            this.SkipLines(scanner, 2);
            stringArray = scanner.nextLine().split(",");
            this.SetCheckbox(stringArray, 7, this.extTimerInitiator[0]);
            this.SetCheckbox(stringArray, 10, this.extTimerFollower[0]);
            stringArray = scanner.nextLine().split(",");
            this.SetIndex(stringArray, 5, this.externalPlugNum);
            this.SkipLines(scanner, 2);
            stringArray = scanner.nextLine().split(",");
            this.SetCheckbox(stringArray, 7, this.extTimerInitiator[1]);
            this.SetCheckbox(stringArray, 10, this.extTimerFollower[1]);
            stringArray = scanner.nextLine().split(",");
            if (stringArray.length > 5) {
                this.externalPA.setText(stringArray[5]);
            }
            this.SkipLines(scanner, 2);
            this.AddOpcode(scanner, 103);
            this.SkipLines(scanner, 2);
            this.AddOpcode(scanner, 67);
            this.AddOpcode(scanner, 53);
            this.SetCheckbox(scanner, 5, this.systemInformation);
            scanner.nextLine();
            this.AddCommaString(scanner, 4, this.supportedLanguages);
            this.AddOpcode(scanner, 145);
            scanner.nextLine();
            this.AddOpcode(scanner, 131);
            this.SkipLines(scanner, 2);
            stringArray = scanner.nextLine().split(",");
            this.SetCheckbox(stringArray, 7, this.pollingInitiator);
            this.SetCheckbox(stringArray, 10, this.pollingFollower);
            scanner.nextLine();
            this.AddOpcode(scanner, 132);
            this.AddOpcode(scanner, 50);
            this.SkipLines(scanner, 2);
            this.AddOpcode(scanner, 159);
            this.SkipLines(scanner, 2);
            this.AddOpcode(scanner, 158);
            scanner.nextLine();
            stringArray = scanner.nextLine().split(",");
            for (n = 0; n < cecVersionList.length; ++n) {
                if (!stringArray[5].equalsIgnoreCase(cecVersionList[n])) continue;
                this.cecVersionBox.setSelectedIndex(n);
            }
            this.SetCheckbox(scanner, 5, this.deckControl);
            this.AddOpcode(scanner, 66);
            this.AddCommaString(scanner, 5, this.deckControlOperands);
            this.SkipLines(scanner, 2);
            this.AddOpcode(scanner, 27);
            scanner.nextLine();
            this.AddCommaString(scanner, 3, this.deckStatusOperands);
            this.AddOpcode(scanner, 26);
            this.SkipLines(scanner, 3);
            this.AddOpcode(scanner, 65);
            this.AddCommaString(scanner, 5, this.playOperands);
            this.SkipLines(scanner, 2);
            this.SetCheckbox(scanner, 5, this.tunerControl);
            this.AddOpcode(scanner, 8);
            this.SkipLines(scanner, 3);
            this.AddOpcode(scanner, 147);
            this.SkipLines(scanner, 3);
            this.AddOpcode(scanner, 146);
            this.SkipLines(scanner, 3);
            this.AddOpcode(scanner, 7);
            this.AddOpcode(scanner, 6);
            this.AddOpcode(scanner, 5);
            this.SkipLines(scanner, 3);
            this.SetCheckbox(scanner, 5, this.vendorSpecific);
            this.ParseVendorID(scanner, this.vendorID);
            this.ParseVendorID(scanner, this.badVendorID);
            this.AddOpcode(scanner, 135);
            this.SkipLines(scanner, 2);
            this.AddOpcode(scanner, 140);
            this.SkipLines(scanner, 2);
            this.AddOpcode(scanner, 137);
            this.SetCheckbox(scanner, 5, this.sendsVendorCommandsToOtherVendors);
            scanner.nextLine();
            this.AddOpcode(scanner, 160);
            this.AddOpcode(scanner, 138);
            this.AddOpcode(scanner, 139);
            this.SetCheckbox(scanner, 5, this.osdDisplay);
            this.AddOpcode(scanner, 100);
            this.SkipLines(scanner, 2);
            this.SetCheckbox(scanner, 5, this.deviceOsdTransfer);
            this.AddOpcode(scanner, 70);
            this.SkipLines(scanner, 2);
            this.AddOpcode(scanner, 71);
            this.SkipLines(scanner, 2);
            stringArray = scanner.nextLine().split(",");
            if (stringArray.length > 5) {
                this.osdName.setText(stringArray[5]);
            }
            this.SetCheckbox(scanner, 5, this.deviceMenuControl);
            this.AddOpcode(scanner, 141);
            this.SkipLines(scanner, 2);
            this.AddOpcode(scanner, 142);
            this.SkipLines(scanner, 2);
            this.SetCheckbox(scanner, 5, this.supportRCPassToRecDevOnActive);
            this.SetCheckbox(scanner, 5, this.supportRCPassToPlayDevOnActive);
            this.SetCheckbox(scanner, 5, this.supportRCPassToTunerOnActive);
            this.SetCheckbox(scanner, 5, this.supportRCPassToAudioSysOnActive);
            for (n = 0; n < 4; ++n) {
                this.AddCommaString(scanner, 5, this.rcPassActiveOperands[n]);
            }
            scanner.nextLine();
            this.SetCheckbox(scanner, 5, this.rcPassthrough);
            this.AddOpcode(scanner, 68);
            this.AddOpcode(scanner, 69);
            this.SetCheckbox(scanner, 5, this.supportRCPassToRecDev);
            this.SetCheckbox(scanner, 5, this.supportRCPassToPlayDev);
            this.SetCheckbox(scanner, 5, this.supportRCPassToTuner);
            this.SetCheckbox(scanner, 5, this.supportRCPassToAudioSys);
            this.SetCheckbox(scanner, 5, this.supportRCPassToTV);
            for (n = 0; n < 6; ++n) {
                this.AddCommaString(scanner, 5, this.rcPassOperands[n]);
            }
            this.SkipLines(scanner, 3);
            this.AddOpcode(scanner, 143);
            scanner.nextLine();
            stringArray = scanner.nextLine().split(",");
            this.SetCheckbox(stringArray, 7, this.initiatorOpcodes[144]);
            this.SetCheckbox(stringArray, 10, this.followerOpcodes[144]);
            if (stringArray[1].equalsIgnoreCase("<Report Power Status>[On]")) {
                stringArray = scanner.nextLine().split(",");
                this.SetCheckbox(stringArray, 7, this.supportReportPowerStandbyInit);
                this.SetCheckbox(stringArray, 10, this.supportReportPowerStandbyFollow);
            }
            scanner.nextLine();
            this.SkipLines(scanner, 2);
            stringArray = scanner.nextLine().split(",");
            this.SetCheckbox(stringArray, 10, this.followerOpcodes[255]);
            this.SetCheckbox(scanner, 5, this.systemAudioControl);
            this.AddOpcode(scanner, 113);
            this.SkipLines(scanner, 2);
            this.AddOpcode(scanner, 125);
            this.SkipLines(scanner, 2);
            this.AddOpcode(scanner, 122);
            this.SkipLines(scanner, 2);
            this.AddOpcode(scanner, 114);
            this.SkipLines(scanner, 4);
            this.AddOpcode(scanner, 112);
            this.SkipLines(scanner, 4);
            this.AddOpcode(scanner, 126);
            this.SkipLines(scanner, 2);
            this.SetCheckbox(scanner, 5, this.audioRateControl);
            stringArray = scanner.nextLine().split(",");
            if (stringArray.length > 5) {
                if (stringArray[5].equalsIgnoreCase("Wide") || stringArray[5].equalsIgnoreCase("Both")) {
                    this.wideAudioRateControl.setEnabled(true);
                }
                if (stringArray[5].equalsIgnoreCase("Narrow") || stringArray[5].equalsIgnoreCase("Both")) {
                    this.narrowAudioRateControl.setEnabled(true);
                }
            }
            scanner.nextLine();
            this.AddOpcode(scanner, 154);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            scanner.close();
            return;
        }
    }

    private void SkipLines(Scanner scanner, int n) {
        for (int i = 0; i < n; ++i) {
            scanner.nextLine();
        }
    }

    private void AddOpcode(Scanner scanner, int n) {
        String[] stringArray = scanner.nextLine().split(",");
        this.SetCheckbox(stringArray, 7, this.initiatorOpcodes[n]);
        this.SetCheckbox(stringArray, 10, this.followerOpcodes[n]);
    }

    private void SetCheckbox(Scanner scanner, int n, QDCheckBox qDCheckBox) {
        String[] stringArray = scanner.nextLine().split(",");
        this.SetCheckbox(stringArray, n, qDCheckBox);
    }

    private void SetCheckbox(String[] stringArray, int n, QDCheckBox qDCheckBox) {
        boolean bl = false;
        if (stringArray.length > n && stringArray[n].length() > 0 && stringArray[n].toUpperCase().charAt(0) == 'Y') {
            bl = true;
        }
        qDCheckBox.setSelected(bl);
    }

    private void SetIndex(String[] stringArray, int n, JComboBox jComboBox) {
        if (stringArray.length > n && stringArray[n].length() > 0) {
            try {
                jComboBox.setSelectedIndex(Integer.parseInt(stringArray[n]));
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Parse error: " + stringArray[n] + " is not a number.", "Error!", 0);
            }
        }
    }

    private void ParseVendorID(Scanner scanner, JFormattedTextField jFormattedTextField) {
        String[] stringArray;
        String[] stringArray2 = scanner.nextLine().split(",");
        if (stringArray2[8].equalsIgnoreCase("(0x000000-0xFFFFFF)") && (stringArray = stringArray2[5].split("x"))[stringArray.length - 1].length() >= 6) {
            jFormattedTextField.setText(stringArray[stringArray.length - 1].substring(0, 6));
        }
    }

    private void AddCommaString(Scanner scanner, int n, JTextField jTextField) {
        String string = scanner.nextLine().replace("\"", " ");
        String[] stringArray = string.split(",");
        string = "";
        for (int i = n; i < stringArray.length; ++i) {
            string = string + stringArray[i];
            if (i == stringArray.length - 1) continue;
            string = string + ",";
        }
        jTextField.setText(string);
    }
}

